/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PufferfishBigModel;
import net.minecraft.client.model.PufferfishMidModel;
import net.minecraft.client.model.PufferfishSmallModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Pufferfish;

public class PufferfishRenderer
extends MobRenderer<Pufferfish, EntityModel<Pufferfish>> {
    private static final ResourceLocation PUFFER_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/fish/pufferfish.png");
    private int puffStateO = 3;
    private final EntityModel<Pufferfish> small;
    private final EntityModel<Pufferfish> mid;
    private final EntityModel<Pufferfish> big = this.getModel();

    public PufferfishRenderer(EntityRendererProvider.Context p_174358_) {
        super(p_174358_, new PufferfishBigModel(p_174358_.bakeLayer(ModelLayers.PUFFERFISH_BIG)), 0.2f);
        this.mid = new PufferfishMidModel<Pufferfish>(p_174358_.bakeLayer(ModelLayers.PUFFERFISH_MEDIUM));
        this.small = new PufferfishSmallModel<Pufferfish>(p_174358_.bakeLayer(ModelLayers.PUFFERFISH_SMALL));
    }

    @Override
    public ResourceLocation getTextureLocation(Pufferfish p_115775_) {
        return PUFFER_LOCATION;
    }

    @Override
    public void render(Pufferfish p_115777_, float p_115778_, float p_115779_, PoseStack p_115780_, MultiBufferSource p_115781_, int p_115782_) {
        int $$6 = p_115777_.getPuffState();
        if ($$6 != this.puffStateO) {
            this.model = $$6 == 0 ? this.small : ($$6 == 1 ? this.mid : this.big);
        }
        this.puffStateO = $$6;
        this.shadowRadius = 0.1f + 0.1f * (float)$$6;
        super.render(p_115777_, p_115778_, p_115779_, p_115780_, p_115781_, p_115782_);
    }

    @Override
    protected void setupRotations(Pufferfish p_320383_, PoseStack p_115763_, float p_115764_, float p_115765_, float p_115766_, float p_320616_) {
        p_115763_.translate(0.0f, Mth.cos(p_115764_ * 0.05f) * 0.08f, 0.0f);
        super.setupRotations(p_320383_, p_115763_, p_115764_, p_115765_, p_115766_, p_320616_);
    }
}

